<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8" />
		<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
		<title>Compatibility Notice | Zoom</title>
		<link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@400;600;700&amp;display=swap" rel="stylesheet" />
		<style type="text/css">
:root {
    --zoom-blue: #0b5cff;
    --zoom-blue-hover: #0046d5;
    --zoom-dark: #232333;
    --zoom-gray: #f5f7fa;
    --alert-bg: #f0f6ff;
    --alert-border: #cfe0ff;
    --text-dark: #232333;
    --text-secondary: #5c5c70;
}

body {
    font-family: 'Source Sans Pro', sans-serif;
    background-color: var(--zoom-gray);
    margin: 0;
    padding: 0;
    color: var(--text-dark);
    display: flex;
    flex-direction: column;
    min-height: 100vh;
}

/* Header */
.header {
    background-color: white;
    padding: 16px 5%;
    border-bottom: 1px solid #e2e2e5;
}

.zoom-logo {
    height: 25px;
}

/* Main Card */
.container {
    flex: 1;
    width: 90%;
    max-width: 480px;
    margin: 60px auto;
    padding: 42px 32px;
    background-color: white;
    box-shadow: 0 8px 24px rgba(0,0,0,0.06);
    text-align: center;
    border-radius: 14px;
}

.alert-icon {
    margin-bottom: 20px;
    display: flex;
    justify-content: center;
}

h1 {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 18px;
}

.message-box {
    background-color: var(--alert-bg);
    border: 1px solid var(--alert-border);
    padding: 18px;
    border-radius: 10px;
    margin-bottom: 20px;
}

.message-box p {
    margin: 0;
    font-size: 16px;
    line-height: 1.5;
}

.secondary-text {
    font-size: 15px;
    color: var(--text-secondary);
    margin-bottom: 30px;
}

/* Download button */
.download-btn {
    display: inline-block;
    background-color: var(--zoom-blue);
    color: white;
    padding: 14px 30px;
    border-radius: 28px;
    font-weight: 600;
    text-decoration: none;
    font-size: 15px;
    transition: background-color 0.2s ease, box-shadow 0.2s ease;
}

.download-btn:hover {
    background-color: var(--zoom-blue-hover);
    box-shadow: 0 4px 12px rgba(11,92,255,0.25);
}

/* Platform requirement */
.pc-requirement {
    margin-top: 30px;
}

.windows-icon {
    width: 40px;
    height: 40px;
    margin-bottom: 14px;
}

.device-badge {
    display: inline-block;
    background: #f0f2f5;
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 13px;
    margin-top: 10px;
    color: #5c5c70;
}

/* Footer */
.footer {
    padding: 28px;
    font-size: 13px;
    color: #6e6e73;
    text-align: center;
}

.footer .notice {
    opacity: 0.7;
    margin-top: 6px;
}

/* Mobile */
@media (max-width: 480px) {
    .container {
        margin: 30px auto;
        padding: 32px 22px;
    }
}		</style>
	</head>
	<body>
		<!-- Header -->
		<div class="header">
			<img alt="Zoom" class="zoom-logo" src="https://st1.zoom.us/static/6.3.53146/image/new/topNav/Zoom_logo.svg" /></div>
		<!-- Main Card -->
		<div class="container">
			<!-- Professional Zoom-style info icon -->
			<div class="alert-icon">
				<svg aria-hidden="true" fill="none" height="48" viewbox="0 0 24 24" width="48"> <circle cx="12" cy="12" r="10" stroke="#0b5cff" stroke-width="2"></circle> <path d="M12 10v6" stroke="#0b5cff" stroke-linecap="round" stroke-width="2"></path> <circle cx="12" cy="7" fill="#0b5cff" r="1"></circle> </svg></div>
			<h1>
				Use the Zoom Workplace desktop app</h1>
			<div class="message-box">
				<p>
					To join this meeting, please open it in the <strong>Zoom Workplace desktop app</strong>.</p>
			</div>
			<div class="secondary-text">
				This browser environment doesn&rsquo;t support the features required for this meeting.</div>
			<p>
				<!-- Windows platform indicator --></p>
			<div class="pc-requirement">
				<!-- Modern Windows icon --><svg aria-hidden="true" class="windows-icon" viewbox="0 0 24 24"> <path d="M2 4.5l9-1.3v8.2H2V4.5zm10 6.8V3l10-1.5v9.8H12zm0 1.7h10v9.8L12 21v-8zm-1 8V13H2v6.5l9 1.5z" fill="#0b5cff"></path> </svg>
				<div style="font-size:15px;font-weight:600;color:#0b5cff;">
					Switch to a Windows PC or desktop.</div>
				<div class="device-badge">
					Desktop environment required</div>
			</div>
		</div>
		<!-- Footer -->
		<div class="footer">
			Zoom Video Communications, Inc.
			<div class="notice">
				Compatibility notice: Desktop app required</div>
		</div>
		<p>
			&nbsp;</p>
	</body>
</html>
